pub use self::texture1d::Texture1d;

        /// Contains the implementation of `Texture1d`.
        pub mod texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing floating-point data.
pub struct Texture1d(TextureAny);

                impl GlObject for Texture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture1d(self.0, Some(self.1))
                                }
                            }

                            impl Texture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t Texture1d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl Texture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<Texture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<Texture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedFloatFormat, mipmaps: MipmapsOption)
                                          -> Result<Texture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedFloatFormat>, mipmaps: MipmapsOption)
                                   -> Result<Texture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyFloatingPoint);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(Texture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<Texture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| Texture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32) -> Result<Texture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| Texture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<Texture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| Texture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture1dMipmap> {
                self.0.mipmap(level).map(|m| Texture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture1d`.
                ///
                /// Can be obtained by calling `Texture1d::mipmap()`, `Texture1d::main_level()`,
                /// `Texture1dLayer::mipmap()` or `Texture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture1d);

                impl<'a> ::std::ops::Deref for Texture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for Texture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture1dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_texture1d::CompressedTexture1d;

        /// Contains the implementation of `CompressedTexture1d`.
        pub mod compressed_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed one-dimensional texture  containing floating-point data.
pub struct CompressedTexture1d(TextureAny);

                impl GlObject for CompressedTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32,
                                                      format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedTexture1d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedFormat(format);
                    Ok(CompressedTexture1d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressed, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture1d { width: width }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressed);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedFormat, mipmaps: CompressedMipmapsOption, width: u32) -> Result<CompressedTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| CompressedTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture1dMipmap> {
                self.0.mipmap(level).map(|m| CompressedTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedTexture1d`.
                ///
                /// Can be obtained by calling `CompressedTexture1d::mipmap()`, `CompressedTexture1d::main_level()`,
                /// `CompressedTexture1dLayer::mipmap()` or `CompressedTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedTexture1d);

                impl<'a> ::std::ops::Deref for CompressedTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::srgb_texture1d::SrgbTexture1d;

        /// Contains the implementation of `SrgbTexture1d`.
        pub mod srgb_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing sRGB floating-point data.
pub struct SrgbTexture1d(TextureAny);

                impl GlObject for SrgbTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t SrgbTexture1d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl SrgbTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<SrgbTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<SrgbTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: SrgbFormat, mipmaps: MipmapsOption)
                                          -> Result<SrgbTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<SrgbFormat>, mipmaps: MipmapsOption)
                                   -> Result<SrgbTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnySrgb);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(SrgbTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<SrgbTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| SrgbTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32) -> Result<SrgbTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| SrgbTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<SrgbTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| SrgbTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture1dMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture1d`.
                ///
                /// Can be obtained by calling `SrgbTexture1d::mipmap()`, `SrgbTexture1d::main_level()`,
                /// `SrgbTexture1dLayer::mipmap()` or `SrgbTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture1d);

                impl<'a> ::std::ops::Deref for SrgbTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture1dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_srgb_texture1d::CompressedSrgbTexture1d;

        /// Contains the implementation of `CompressedSrgbTexture1d`.
        pub mod compressed_srgb_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed one-dimensional texture  containing sRGB floating-point data.
pub struct CompressedSrgbTexture1d(TextureAny);

                impl GlObject for CompressedSrgbTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedSrgbTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedSrgbTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedSrgbTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedSrgbTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedSrgbTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedSrgbTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedSrgbTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedSrgbTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedSrgbTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32,
                                                      format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedSrgbTexture1d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedSrgbFormat(format);
                    Ok(CompressedSrgbTexture1d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressedSrgb, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture1d { width: width }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedSrgbTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedSrgbFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedSrgbTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressedSrgb);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedSrgbTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption, width: u32) -> Result<CompressedSrgbTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| CompressedSrgbTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedSrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedSrgbTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedSrgbTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture1dMipmap> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedSrgbTexture1d`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture1d::mipmap()`, `CompressedSrgbTexture1d::main_level()`,
                /// `CompressedSrgbTexture1dLayer::mipmap()` or `CompressedSrgbTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedSrgbTexture1d);

                impl<'a> ::std::ops::Deref for CompressedSrgbTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedSrgbTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedSrgbFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedSrgbTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::integral_texture1d::IntegralTexture1d;

        /// Contains the implementation of `IntegralTexture1d`.
        pub mod integral_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing signed integral data.
pub struct IntegralTexture1d(TextureAny);

                impl GlObject for IntegralTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t IntegralTexture1d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl IntegralTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<IntegralTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<IntegralTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedIntFormat, mipmaps: MipmapsOption)
                                          -> Result<IntegralTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedIntFormat>, mipmaps: MipmapsOption)
                                   -> Result<IntegralTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyIntegral);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(IntegralTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<IntegralTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| IntegralTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32) -> Result<IntegralTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| IntegralTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<IntegralTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| IntegralTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture1dMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture1d`.
                ///
                /// Can be obtained by calling `IntegralTexture1d::mipmap()`, `IntegralTexture1d::main_level()`,
                /// `IntegralTexture1dLayer::mipmap()` or `IntegralTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture1d);

                impl<'a> ::std::ops::Deref for IntegralTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture1dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture1d::UnsignedTexture1d;

        /// Contains the implementation of `UnsignedTexture1d`.
        pub mod unsigned_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing unsigned integral data.
pub struct UnsignedTexture1d(TextureAny);

                impl GlObject for UnsignedTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t UnsignedTexture1d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl UnsignedTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<UnsignedTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<UnsignedTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedUintFormat, mipmaps: MipmapsOption)
                                          -> Result<UnsignedTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedUintFormat>, mipmaps: MipmapsOption)
                                   -> Result<UnsignedTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyUnsigned);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(UnsignedTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<UnsignedTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| UnsignedTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32) -> Result<UnsignedTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| UnsignedTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<UnsignedTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| UnsignedTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture1dMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture1d`.
                ///
                /// Can be obtained by calling `UnsignedTexture1d::mipmap()`, `UnsignedTexture1d::main_level()`,
                /// `UnsignedTexture1dLayer::mipmap()` or `UnsignedTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture1d);

                impl<'a> ::std::ops::Deref for UnsignedTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture1dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture1d::DepthTexture1d;

        /// Contains the implementation of `DepthTexture1d`.
        pub mod depth_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing depth data.
pub struct DepthTexture1d(TextureAny);

                impl GlObject for DepthTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture1d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture1d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture1d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture1d(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture1d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture1d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for &'t DepthTexture1d {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepth);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<DepthTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| DepthTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32) -> Result<DepthTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| DepthTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<DepthTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| DepthTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture1dMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture1d`.
                ///
                /// Can be obtained by calling `DepthTexture1d::mipmap()`, `DepthTexture1d::main_level()`,
                /// `DepthTexture1dLayer::mipmap()` or `DepthTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture1d);

                impl<'a> ::std::ops::Deref for DepthTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture1dMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture1d::StencilTexture1d;

        /// Contains the implementation of `StencilTexture1d`.
        pub mod stencil_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing stencil data.
pub struct StencilTexture1d(TextureAny);

                impl GlObject for StencilTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for &'t StencilTexture1d {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl StencilTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<StencilTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<StencilTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: StencilFormat, mipmaps: MipmapsOption)
                                          -> Result<StencilTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<StencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<StencilTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyStencil);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(StencilTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<StencilTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| StencilTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32) -> Result<StencilTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| StencilTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<StencilTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| StencilTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture1dMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture1d`.
                ///
                /// Can be obtained by calling `StencilTexture1d::mipmap()`, `StencilTexture1d::main_level()`,
                /// `StencilTexture1dLayer::mipmap()` or `StencilTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture1d);

                impl<'a> ::std::ops::Deref for StencilTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture1dMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture1d::DepthStencilTexture1d;

        /// Contains the implementation of `DepthStencilTexture1d`.
        pub mod depth_stencil_texture1d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A one-dimensional texture  containing both depth and stencil data.
pub struct DepthStencilTexture1d(TextureAny);

                impl GlObject for DepthStencilTexture1d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture1d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture1d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for &'t DepthStencilTexture1d {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthStencilTexture1d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthStencilTexture1d, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthStencilTexture1d, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthStencilFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthStencilTexture1d, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthStencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthStencilTexture1d, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepthStencil);
                    let RawImage1d { data, width, format: client_format } = data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthStencilTexture1d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1d { width: width }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32)
                                -> Result<DepthStencilTexture1d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1d { width: width }).map(|t| DepthStencilTexture1d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32) -> Result<DepthStencilTexture1d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width });
            t.map(|t| DepthStencilTexture1d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32) -> Result<DepthStencilTexture1d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1d { width: width }).map(|t| DepthStencilTexture1d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture1d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture1d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture1dMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture1dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture1dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture1d`.
                ///
                /// Can be obtained by calling `DepthStencilTexture1d::mipmap()`, `DepthStencilTexture1d::main_level()`,
                /// `DepthStencilTexture1dLayer::mipmap()` or `DepthStencilTexture1dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture1dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture1d);

                impl<'a> ::std::ops::Deref for DepthStencilTexture1dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture1dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture1d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture1dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture1dMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture2d::Texture2d;

        /// Contains the implementation of `Texture2d`.
        pub mod texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing floating-point data.
pub struct Texture2d(TextureAny);

                impl GlObject for Texture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2d(self.0, Some(self.1))
                                }
                            }

                            impl Texture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t Texture2d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl Texture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<Texture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<Texture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedFloatFormat, mipmaps: MipmapsOption)
                                          -> Result<Texture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedFloatFormat>, mipmaps: MipmapsOption)
                                   -> Result<Texture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyFloatingPoint);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(Texture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<Texture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| Texture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<Texture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| Texture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<Texture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| Texture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM. This method may only read `U8U8U8U8`
                /// data, as it is the only format guaranteed to be supported across all OpenGL
                /// versions.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub fn read<T>(&self) -> T where T: Texture2dDataSink<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read() }
                }
            
                /// Reads the content of the texture into a buffer in video memory. This method may
                /// only read `U8U8U8U8` data, as it is the only format guaranteed to be supported
                /// across all OpenGL versions.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub fn read_to_pixel_buffer(&self) -> PixelBuffer<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read_to_pixel_buffer() }
                }
            
                /// Unsafely reads the content of the texture to RAM in the specified pixel format.
                /// It is possible that the current OpenGL context does not support the given
                /// format, in which case the returned data will be invalid.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub unsafe fn unchecked_read<T, P>(&self) -> T where T: Texture2dDataSink<P>, P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    self.0.main_level().first_layer().into_image(None).unwrap().raw_read(&rect)
                }
            
                /// Unsafely reads the content of the texture into a buffer in video memory. It is
                /// possible that the current OpenGL context does not support the given format, in
                /// which case the returned data will be invalid.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub unsafe fn unchecked_read_to_pixel_buffer<P>(&self) -> PixelBuffer<P> where P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    let pb = PixelBuffer::new_empty(self.0.get_context(),
                                                    rect.width as usize * rect.height as usize);
                    self.0.main_level().first_layer().into_image(None).unwrap()
                          .raw_read_to_pixel_buffer(&rect, &pb);
                    pb
                }
            
                /// Uploads some data in the texture.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                
                #[inline]
                pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                    self.main_level().write(rect, data)
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dMipmap> {
                self.0.mipmap(level).map(|m| Texture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture2d`.
                ///
                /// Can be obtained by calling `Texture2d::mipmap()`, `Texture2d::main_level()`,
                /// `Texture2dLayer::mipmap()` or `Texture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture2d);

                impl<'a> ::std::ops::Deref for Texture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                    /// Uploads some data in the texture level.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                    
                    pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                        let RawImage2d { data, width, height, format: client_format } =
                                                data.into_raw();

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let client_format = ClientFormatAny::ClientFormat(client_format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, true).unwrap()
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for Texture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture2dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_texture2d::CompressedTexture2d;

        /// Contains the implementation of `CompressedTexture2d`.
        pub mod compressed_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed two-dimensional texture  containing floating-point data.
pub struct CompressedTexture2d(TextureAny);

                impl GlObject for CompressedTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32, height: u32,
                                                      format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedTexture2d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedFormat(format);
                    Ok(CompressedTexture2d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressed, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressed);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32) -> Result<CompressedTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| CompressedTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM. This method may only read `U8U8U8U8`
                /// data, as it is the only format guaranteed to be supported across all OpenGL
                /// versions.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub fn read<T>(&self) -> T where T: Texture2dDataSink<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read() }
                }
            
                /// Reads the content of the texture into a buffer in video memory. This method may
                /// only read `U8U8U8U8` data, as it is the only format guaranteed to be supported
                /// across all OpenGL versions.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub fn read_to_pixel_buffer(&self) -> PixelBuffer<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read_to_pixel_buffer() }
                }
            
                /// Unsafely reads the content of the texture to RAM in the specified pixel format.
                /// It is possible that the current OpenGL context does not support the given
                /// format, in which case the returned data will be invalid.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub unsafe fn unchecked_read<T, P>(&self) -> T where T: Texture2dDataSink<P>, P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    self.0.main_level().first_layer().into_image(None).unwrap().raw_read(&rect)
                }
            
                /// Unsafely reads the content of the texture into a buffer in video memory. It is
                /// possible that the current OpenGL context does not support the given format, in
                /// which case the returned data will be invalid.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub unsafe fn unchecked_read_to_pixel_buffer<P>(&self) -> PixelBuffer<P> where P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    let pb = PixelBuffer::new_empty(self.0.get_context(),
                                                    rect.width as usize * rect.height as usize);
                    self.0.main_level().first_layer().into_image(None).unwrap()
                          .raw_read_to_pixel_buffer(&rect, &pb);
                    pb
                }
            
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
                /// Uploads some data in the texture.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                 ///
                /// Calling this for compressed textures will result in a panic of type INVALID_OPERATION
                /// if `Rect::bottom` or `Rect::width` is not equal to 0 (border). In addition, the contents
                /// of any texel outside the region modified by such a call are undefined. These
                /// restrictions may be relaxed for specific compressed internal formats whose images
                /// are easily edited.
            
                #[inline]
                pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                    self.main_level().write(rect, data)
                }
            
                /// Uploads some data in the texture by using a compressed format as input.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                ///
                /// Calling this will result in a panic of type INVALID_OPERATION error if `Rect::width`
                /// or `Rect::height` is not equal to 0 (border), or if the written dimensions do not match
                /// the original texture dimensions. The contents of any texel outside the region modified
                /// by the call are undefined. These restrictions may be relaxed for specific compressed
                /// internal formats whose images are easily edited.
                #[inline]
                pub fn write_compressed_data(&self, rect: Rect, data: &[u8],
                                             width: u32, height: u32, format: CompressedFormat)
                                             -> Result<(), ()>
                {
                    // FIXME is having width and height as parameter redundant as rect kinda of
                    // already provides them?
                    self.main_level().write_compressed_data(rect, data, width, height, format)
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture2dMipmap> {
                self.0.mipmap(level).map(|m| CompressedTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedTexture2d`.
                ///
                /// Can be obtained by calling `CompressedTexture2d::mipmap()`, `CompressedTexture2d::main_level()`,
                /// `CompressedTexture2dLayer::mipmap()` or `CompressedTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedTexture2d);

                impl<'a> ::std::ops::Deref for CompressedTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                    /// Uploads some data in the texture level.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                     ///
                    /// Calling this for compressed textures will result in a panic of type INVALID_OPERATION
                    /// if `Rect::bottom` or `Rect::width` is not equal to 0 (border). In addition, the contents
                    /// of any texel outside the region modified by such a call are undefined. These
                    /// restrictions may be relaxed for specific compressed internal formats whose images
                    /// are easily edited.
                
                    pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                        let RawImage2d { data, width, height, format: client_format } =
                                                data.into_raw();

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let client_format = ClientFormatAny::ClientFormat(client_format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, true).unwrap()
                    }
                
                    /// Uploads some data in the texture level by using a compressed format as input.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                    ///
                    /// Calling this will result in a panic of type INVALID_OPERATION error if `Rect::width`
                    /// or `Rect::height` is not equal to 0 (border), or if the written dimensions do not match
                    /// the original texture dimensions. The contents of any texel outside the region modified
                    /// by the call are undefined. These restrictions may be relaxed for specific compressed
                    /// internal formats whose images are easily edited.
                    pub fn write_compressed_data(&self, rect: Rect, data: &[u8],
                                                 width: u32, height: u32, format: CompressedFormat)
                                                 -> Result<(), ()>
                    {
                        // FIXME is having width and height as parameter redundant as rect kinda of
                        // already provides them?

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let data = Cow::Borrowed(data.as_ref());
                        let client_format = ClientFormatAny::CompressedFormat(format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, false)
                    }
                
                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::srgb_texture2d::SrgbTexture2d;

        /// Contains the implementation of `SrgbTexture2d`.
        pub mod srgb_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing sRGB floating-point data.
pub struct SrgbTexture2d(TextureAny);

                impl GlObject for SrgbTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t SrgbTexture2d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl SrgbTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<SrgbTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<SrgbTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: SrgbFormat, mipmaps: MipmapsOption)
                                          -> Result<SrgbTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<SrgbFormat>, mipmaps: MipmapsOption)
                                   -> Result<SrgbTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnySrgb);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(SrgbTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<SrgbTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| SrgbTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<SrgbTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| SrgbTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<SrgbTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| SrgbTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM. This method may only read `U8U8U8U8`
                /// data, as it is the only format guaranteed to be supported across all OpenGL
                /// versions.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub fn read<T>(&self) -> T where T: Texture2dDataSink<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read() }
                }
            
                /// Reads the content of the texture into a buffer in video memory. This method may
                /// only read `U8U8U8U8` data, as it is the only format guaranteed to be supported
                /// across all OpenGL versions.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub fn read_to_pixel_buffer(&self) -> PixelBuffer<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read_to_pixel_buffer() }
                }
            
                /// Unsafely reads the content of the texture to RAM in the specified pixel format.
                /// It is possible that the current OpenGL context does not support the given
                /// format, in which case the returned data will be invalid.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub unsafe fn unchecked_read<T, P>(&self) -> T where T: Texture2dDataSink<P>, P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    self.0.main_level().first_layer().into_image(None).unwrap().raw_read(&rect)
                }
            
                /// Unsafely reads the content of the texture into a buffer in video memory. It is
                /// possible that the current OpenGL context does not support the given format, in
                /// which case the returned data will be invalid.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub unsafe fn unchecked_read_to_pixel_buffer<P>(&self) -> PixelBuffer<P> where P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    let pb = PixelBuffer::new_empty(self.0.get_context(),
                                                    rect.width as usize * rect.height as usize);
                    self.0.main_level().first_layer().into_image(None).unwrap()
                          .raw_read_to_pixel_buffer(&rect, &pb);
                    pb
                }
            
                /// Uploads some data in the texture.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                
                #[inline]
                pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                    self.main_level().write(rect, data)
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture2d`.
                ///
                /// Can be obtained by calling `SrgbTexture2d::mipmap()`, `SrgbTexture2d::main_level()`,
                /// `SrgbTexture2dLayer::mipmap()` or `SrgbTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture2d);

                impl<'a> ::std::ops::Deref for SrgbTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                    /// Uploads some data in the texture level.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                    
                    pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                        let RawImage2d { data, width, height, format: client_format } =
                                                data.into_raw();

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let client_format = ClientFormatAny::ClientFormat(client_format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, true).unwrap()
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture2dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_srgb_texture2d::CompressedSrgbTexture2d;

        /// Contains the implementation of `CompressedSrgbTexture2d`.
        pub mod compressed_srgb_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed two-dimensional texture  containing sRGB floating-point data.
pub struct CompressedSrgbTexture2d(TextureAny);

                impl GlObject for CompressedSrgbTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedSrgbTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedSrgbTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedSrgbTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedSrgbTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedSrgbTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedSrgbTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedSrgbTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedSrgbTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedSrgbTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32, height: u32,
                                                      format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedSrgbTexture2d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedSrgbFormat(format);
                    Ok(CompressedSrgbTexture2d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressedSrgb, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedSrgbTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedSrgbFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedSrgbTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressedSrgb);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedSrgbTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32) -> Result<CompressedSrgbTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| CompressedSrgbTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedSrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedSrgbTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedSrgbTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM. This method may only read `U8U8U8U8`
                /// data, as it is the only format guaranteed to be supported across all OpenGL
                /// versions.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub fn read<T>(&self) -> T where T: Texture2dDataSink<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read() }
                }
            
                /// Reads the content of the texture into a buffer in video memory. This method may
                /// only read `U8U8U8U8` data, as it is the only format guaranteed to be supported
                /// across all OpenGL versions.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub fn read_to_pixel_buffer(&self) -> PixelBuffer<(u8, u8, u8, u8)> {
                    unsafe { self.unchecked_read_to_pixel_buffer() }
                }
            
                /// Unsafely reads the content of the texture to RAM in the specified pixel format.
                /// It is possible that the current OpenGL context does not support the given
                /// format, in which case the returned data will be invalid.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                /// Use `read_to_pixel_buffer` instead.
                #[inline]
                pub unsafe fn unchecked_read<T, P>(&self) -> T where T: Texture2dDataSink<P>, P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    self.0.main_level().first_layer().into_image(None).unwrap().raw_read(&rect)
                }
            
                /// Unsafely reads the content of the texture into a buffer in video memory. It is
                /// possible that the current OpenGL context does not support the given format, in
                /// which case the returned data will be invalid.
                ///
                /// This operation copies the texture's data into a buffer in video memory
                /// (a pixel buffer). Contrary to the `read` function, this operation is
                /// done asynchronously and doesn't need a synchronization.
                #[inline]
                pub unsafe fn unchecked_read_to_pixel_buffer<P>(&self) -> PixelBuffer<P> where P: PixelValue {
                    let rect = Rect { left: 0, bottom: 0, width: self.get_width(),
                                       height: self.get_height().unwrap_or(1) };
                    let pb = PixelBuffer::new_empty(self.0.get_context(),
                                                    rect.width as usize * rect.height as usize);
                    self.0.main_level().first_layer().into_image(None).unwrap()
                          .raw_read_to_pixel_buffer(&rect, &pb);
                    pb
                }
            
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
                /// Uploads some data in the texture.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                 ///
                /// Calling this for compressed textures will result in a panic of type INVALID_OPERATION
                /// if `Rect::bottom` or `Rect::width` is not equal to 0 (border). In addition, the contents
                /// of any texel outside the region modified by such a call are undefined. These
                /// restrictions may be relaxed for specific compressed internal formats whose images
                /// are easily edited.
            
                #[inline]
                pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                    self.main_level().write(rect, data)
                }
            
                /// Uploads some data in the texture by using a compressed format as input.
                ///
                /// Note that this may cause a synchronization if you use the texture right before
                /// or right after this call. Prefer creating a whole new texture if you change a
                /// huge part of it.
                ///
                /// ## Panic
                ///
                /// Panics if the the dimensions of `data` don't match the `Rect`.
                ///
                /// Calling this will result in a panic of type INVALID_OPERATION error if `Rect::width`
                /// or `Rect::height` is not equal to 0 (border), or if the written dimensions do not match
                /// the original texture dimensions. The contents of any texel outside the region modified
                /// by the call are undefined. These restrictions may be relaxed for specific compressed
                /// internal formats whose images are easily edited.
                #[inline]
                pub fn write_compressed_data(&self, rect: Rect, data: &[u8],
                                             width: u32, height: u32, format: CompressedSrgbFormat)
                                             -> Result<(), ()>
                {
                    // FIXME is having width and height as parameter redundant as rect kinda of
                    // already provides them?
                    self.main_level().write_compressed_data(rect, data, width, height, format)
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture2dMipmap> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedSrgbTexture2d`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture2d::mipmap()`, `CompressedSrgbTexture2d::main_level()`,
                /// `CompressedSrgbTexture2dLayer::mipmap()` or `CompressedSrgbTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedSrgbTexture2d);

                impl<'a> ::std::ops::Deref for CompressedSrgbTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedSrgbTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                    /// Uploads some data in the texture level.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                     ///
                    /// Calling this for compressed textures will result in a panic of type INVALID_OPERATION
                    /// if `Rect::bottom` or `Rect::width` is not equal to 0 (border). In addition, the contents
                    /// of any texel outside the region modified by such a call are undefined. These
                    /// restrictions may be relaxed for specific compressed internal formats whose images
                    /// are easily edited.
                
                    pub fn write<'a, T>(&self, rect: Rect, data: T) where T: Texture2dDataSource<'a> {
                        let RawImage2d { data, width, height, format: client_format } =
                                                data.into_raw();

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let client_format = ClientFormatAny::ClientFormat(client_format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, true).unwrap()
                    }
                
                    /// Uploads some data in the texture level by using a compressed format as input.
                    ///
                    /// Note that this may cause a synchronization if you use the texture right before
                    /// or right after this call.
                    ///
                    /// ## Panic
                    ///
                    /// Panics if the the dimensions of `data` don't match the `Rect`.
                    ///
                    /// Calling this will result in a panic of type INVALID_OPERATION error if `Rect::width`
                    /// or `Rect::height` is not equal to 0 (border), or if the written dimensions do not match
                    /// the original texture dimensions. The contents of any texel outside the region modified
                    /// by the call are undefined. These restrictions may be relaxed for specific compressed
                    /// internal formats whose images are easily edited.
                    pub fn write_compressed_data(&self, rect: Rect, data: &[u8],
                                                 width: u32, height: u32, format: CompressedSrgbFormat)
                                                 -> Result<(), ()>
                    {
                        // FIXME is having width and height as parameter redundant as rect kinda of
                        // already provides them?

                        assert_eq!(width, rect.width);
                        assert_eq!(height, rect.height);

                        let data = Cow::Borrowed(data.as_ref());
                        let client_format = ClientFormatAny::CompressedSrgbFormat(format);

                        self.0.upload_texture(rect.left, rect.bottom, 0, (client_format, data),
                                              width, Some(height), None, false)
                    }
                
                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedSrgbFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedSrgbTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::integral_texture2d::IntegralTexture2d;

        /// Contains the implementation of `IntegralTexture2d`.
        pub mod integral_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing signed integral data.
pub struct IntegralTexture2d(TextureAny);

                impl GlObject for IntegralTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t IntegralTexture2d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl IntegralTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<IntegralTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<IntegralTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedIntFormat, mipmaps: MipmapsOption)
                                          -> Result<IntegralTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedIntFormat>, mipmaps: MipmapsOption)
                                   -> Result<IntegralTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyIntegral);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(IntegralTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<IntegralTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| IntegralTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<IntegralTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| IntegralTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<IntegralTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| IntegralTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture2d`.
                ///
                /// Can be obtained by calling `IntegralTexture2d::mipmap()`, `IntegralTexture2d::main_level()`,
                /// `IntegralTexture2dLayer::mipmap()` or `IntegralTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture2d);

                impl<'a> ::std::ops::Deref for IntegralTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture2dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture2d::UnsignedTexture2d;

        /// Contains the implementation of `UnsignedTexture2d`.
        pub mod unsigned_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing unsigned integral data.
pub struct UnsignedTexture2d(TextureAny);

                impl GlObject for UnsignedTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t UnsignedTexture2d {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl UnsignedTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<UnsignedTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<UnsignedTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedUintFormat, mipmaps: MipmapsOption)
                                          -> Result<UnsignedTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedUintFormat>, mipmaps: MipmapsOption)
                                   -> Result<UnsignedTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyUnsigned);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(UnsignedTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<UnsignedTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| UnsignedTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<UnsignedTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| UnsignedTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<UnsignedTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| UnsignedTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture2d`.
                ///
                /// Can be obtained by calling `UnsignedTexture2d::mipmap()`, `UnsignedTexture2d::main_level()`,
                /// `UnsignedTexture2dLayer::mipmap()` or `UnsignedTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture2d);

                impl<'a> ::std::ops::Deref for UnsignedTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture2dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture2d::DepthTexture2d;

        /// Contains the implementation of `DepthTexture2d`.
        pub mod depth_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing depth data.
pub struct DepthTexture2d(TextureAny);

                impl GlObject for DepthTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture2d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture2d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2d(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture2d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture2d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for &'t DepthTexture2d {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepth);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<DepthTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| DepthTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<DepthTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| DepthTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<DepthTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| DepthTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture2d`.
                ///
                /// Can be obtained by calling `DepthTexture2d::mipmap()`, `DepthTexture2d::main_level()`,
                /// `DepthTexture2dLayer::mipmap()` or `DepthTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture2d);

                impl<'a> ::std::ops::Deref for DepthTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture2dMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture2d::StencilTexture2d;

        /// Contains the implementation of `StencilTexture2d`.
        pub mod stencil_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing stencil data.
pub struct StencilTexture2d(TextureAny);

                impl GlObject for StencilTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for &'t StencilTexture2d {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl StencilTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<StencilTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<StencilTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: StencilFormat, mipmaps: MipmapsOption)
                                          -> Result<StencilTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<StencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<StencilTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyStencil);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(StencilTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<StencilTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| StencilTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<StencilTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| StencilTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<StencilTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| StencilTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture2d`.
                ///
                /// Can be obtained by calling `StencilTexture2d::mipmap()`, `StencilTexture2d::main_level()`,
                /// `StencilTexture2dLayer::mipmap()` or `StencilTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture2d);

                impl<'a> ::std::ops::Deref for StencilTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture2dMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture2d::DepthStencilTexture2d;

        /// Contains the implementation of `DepthStencilTexture2d`.
        pub mod depth_stencil_texture2d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing both depth and stencil data.
pub struct DepthStencilTexture2d(TextureAny);

                impl GlObject for DepthStencilTexture2d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture2d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture2d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for &'t DepthStencilTexture2d {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthStencilTexture2d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthStencilTexture2d, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthStencilTexture2d, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthStencilFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthStencilTexture2d, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthStencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthStencilTexture2d, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepthStencil);
                    let RawImage2d { data, width, height, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthStencilTexture2d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2d { width: width, height: height }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32)
                                -> Result<DepthStencilTexture2d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| DepthStencilTexture2d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<DepthStencilTexture2d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height });
            t.map(|t| DepthStencilTexture2d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32) -> Result<DepthStencilTexture2d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2d { width: width, height: height }).map(|t| DepthStencilTexture2d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture2d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture2d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture2d`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2d::mipmap()`, `DepthStencilTexture2d::main_level()`,
                /// `DepthStencilTexture2dLayer::mipmap()` or `DepthStencilTexture2dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture2d);

                impl<'a> ::std::ops::Deref for DepthStencilTexture2dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture2dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture2dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture2dMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture2d_multisample::Texture2dMultisample;

        /// Contains the implementation of `Texture2dMultisample`.
        pub mod texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing floating-point data.
pub struct Texture2dMultisample(TextureAny);

                impl GlObject for Texture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture2dMultisample {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dMultisample(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture2dMultisample> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dMultisample(self.0, Some(self.1))
                                }
                            }

                            impl Texture2dMultisample {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture2dMultisample> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t Texture2dMultisample {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl Texture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<Texture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| Texture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<Texture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| Texture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<Texture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| Texture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| Texture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture2dMultisample`.
                ///
                /// Can be obtained by calling `Texture2dMultisample::mipmap()`, `Texture2dMultisample::main_level()`,
                /// `Texture2dMultisampleLayer::mipmap()` or `Texture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture2dMultisample);

                impl<'a> ::std::ops::Deref for Texture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for Texture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::integral_texture2d_multisample::IntegralTexture2dMultisample;

        /// Contains the implementation of `IntegralTexture2dMultisample`.
        pub mod integral_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing signed integral data.
pub struct IntegralTexture2dMultisample(TextureAny);

                impl GlObject for IntegralTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture2dMultisample {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dMultisample(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture2dMultisample> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dMultisample(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture2dMultisample {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture2dMultisample> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t IntegralTexture2dMultisample {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl IntegralTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<IntegralTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| IntegralTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<IntegralTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| IntegralTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<IntegralTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| IntegralTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture2dMultisample`.
                ///
                /// Can be obtained by calling `IntegralTexture2dMultisample::mipmap()`, `IntegralTexture2dMultisample::main_level()`,
                /// `IntegralTexture2dMultisampleLayer::mipmap()` or `IntegralTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture2dMultisample);

                impl<'a> ::std::ops::Deref for IntegralTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::srgb_texture2d_multisample::SrgbTexture2dMultisample;

        /// Contains the implementation of `SrgbTexture2dMultisample`.
        pub mod srgb_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing sRGB floating-point data.
pub struct SrgbTexture2dMultisample(TextureAny);

                impl GlObject for SrgbTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture2dMultisample {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dMultisample(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture2dMultisample> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dMultisample(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture2dMultisample {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture2dMultisample> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t SrgbTexture2dMultisample {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl SrgbTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<SrgbTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| SrgbTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<SrgbTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| SrgbTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<SrgbTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| SrgbTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture2dMultisample`.
                ///
                /// Can be obtained by calling `SrgbTexture2dMultisample::mipmap()`, `SrgbTexture2dMultisample::main_level()`,
                /// `SrgbTexture2dMultisampleLayer::mipmap()` or `SrgbTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture2dMultisample);

                impl<'a> ::std::ops::Deref for SrgbTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture2d_multisample::UnsignedTexture2dMultisample;

        /// Contains the implementation of `UnsignedTexture2dMultisample`.
        pub mod unsigned_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing unsigned integral data.
pub struct UnsignedTexture2dMultisample(TextureAny);

                impl GlObject for UnsignedTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture2dMultisample {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dMultisample(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture2dMultisample> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dMultisample(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture2dMultisample {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture2dMultisample> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for &'t UnsignedTexture2dMultisample {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl UnsignedTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<UnsignedTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| UnsignedTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<UnsignedTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| UnsignedTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<UnsignedTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| UnsignedTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Starts drawing on the texture.
                ///
                /// All the function calls to the framebuffer will draw on the texture instead
                /// of the screen.
                ///
                /// ## Low-level information
                ///
                /// The first time that this function is called, a FrameBuffer Object will be
                /// created and cached. The following calls to `as_surface` will load the existing
                /// FBO and re-use it. When the texture is destroyed, the FBO is destroyed too.
                ///
                #[inline]
                pub fn as_surface<'a>(&'a self) -> framebuffer::SimpleFrameBuffer<'a> {
                    framebuffer::SimpleFrameBuffer::new(self.0.get_context(), self).unwrap()
                }
            
            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture2dMultisample`.
                ///
                /// Can be obtained by calling `UnsignedTexture2dMultisample::mipmap()`, `UnsignedTexture2dMultisample::main_level()`,
                /// `UnsignedTexture2dMultisampleLayer::mipmap()` or `UnsignedTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture2dMultisample);

                impl<'a> ::std::ops::Deref for UnsignedTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture2d_multisample::DepthTexture2dMultisample;

        /// Contains the implementation of `DepthTexture2dMultisample`.
        pub mod depth_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing depth data.
pub struct DepthTexture2dMultisample(TextureAny);

                impl GlObject for DepthTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture2dMultisample {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dMultisample(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture2dMultisample> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dMultisample(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture2dMultisample {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture2dMultisample> {
                                    Sampler(self, Default::default())
                                }
                            }
                        

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for &'t DepthTexture2dMultisample {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<DepthTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| DepthTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<DepthTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| DepthTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<DepthTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| DepthTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture2dMultisample`.
                ///
                /// Can be obtained by calling `DepthTexture2dMultisample::mipmap()`, `DepthTexture2dMultisample::main_level()`,
                /// `DepthTexture2dMultisampleLayer::mipmap()` or `DepthTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture2dMultisample);

                impl<'a> ::std::ops::Deref for DepthTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture2d_multisample::StencilTexture2dMultisample;

        /// Contains the implementation of `StencilTexture2dMultisample`.
        pub mod stencil_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing stencil data.
pub struct StencilTexture2dMultisample(TextureAny);

                impl GlObject for StencilTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for &'t StencilTexture2dMultisample {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl StencilTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<StencilTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| StencilTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<StencilTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| StencilTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<StencilTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| StencilTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture2dMultisample`.
                ///
                /// Can be obtained by calling `StencilTexture2dMultisample::mipmap()`, `StencilTexture2dMultisample::main_level()`,
                /// `StencilTexture2dMultisampleLayer::mipmap()` or `StencilTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture2dMultisample);

                impl<'a> ::std::ops::Deref for StencilTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture2d_multisample::DepthStencilTexture2dMultisample;

        /// Contains the implementation of `DepthStencilTexture2dMultisample`.
        pub mod depth_stencil_texture2d_multisample {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A two-dimensional texture  containing both depth and stencil data.
pub struct DepthStencilTexture2dMultisample(TextureAny);

                impl GlObject for DepthStencilTexture2dMultisample {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture2dMultisample {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture2dMultisample {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for &'t DepthStencilTexture2dMultisample {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.0.main_level().first_layer().into_image(None).unwrap())
                            }
                        }
                    
impl DepthStencilTexture2dMultisample {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, samples: u32)
                                -> Result<DepthStencilTexture2dMultisample, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| DepthStencilTexture2dMultisample(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<DepthStencilTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples });
            t.map(|t| DepthStencilTexture2dMultisample(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, samples: u32) -> Result<DepthStencilTexture2dMultisample, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisample { width: width, height: height, samples: samples }).map(|t| DepthStencilTexture2dMultisample(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture2dMultisample {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture2dMultisample(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dMultisampleMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dMultisampleMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dMultisampleMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture2dMultisample`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2dMultisample::mipmap()`, `DepthStencilTexture2dMultisample::main_level()`,
                /// `DepthStencilTexture2dMultisampleLayer::mipmap()` or `DepthStencilTexture2dMultisampleLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dMultisampleMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture2dMultisample);

                impl<'a> ::std::ops::Deref for DepthStencilTexture2dMultisampleMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture2dMultisampleMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2dMultisample {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture2dMultisampleMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture2dMultisampleMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture3d::Texture3d;

        /// Contains the implementation of `Texture3d`.
        pub mod texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing floating-point data.
pub struct Texture3d(TextureAny);

                impl GlObject for Texture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture3d(self.0, Some(self.1))
                                }
                            }

                            impl Texture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl Texture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<Texture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    Texture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<Texture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    Texture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedFloatFormat, mipmaps: MipmapsOption)
                                          -> Result<Texture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    Texture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedFloatFormat>, mipmaps: MipmapsOption)
                                   -> Result<Texture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyFloatingPoint);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(Texture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<Texture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| Texture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<Texture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| Texture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<Texture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| Texture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture3dMipmap> {
                self.0.mipmap(level).map(|m| Texture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture3d`.
                ///
                /// Can be obtained by calling `Texture3d::mipmap()`, `Texture3d::main_level()`,
                /// `Texture3dLayer::mipmap()` or `Texture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture3d);

                impl<'a> ::std::ops::Deref for Texture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for Texture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture3dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_texture3d::CompressedTexture3d;

        /// Contains the implementation of `CompressedTexture3d`.
        pub mod compressed_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed three-dimensional texture  containing floating-point data.
pub struct CompressedTexture3d(TextureAny);

                impl GlObject for CompressedTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedTexture3d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32, height: u32, depth: u32,
                                                      format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedTexture3d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedFormat(format);
                    Ok(CompressedTexture3d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressed, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressed);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32, depth: u32) -> Result<CompressedTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| CompressedTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture3dMipmap> {
                self.0.mipmap(level).map(|m| CompressedTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedTexture3d`.
                ///
                /// Can be obtained by calling `CompressedTexture3d::mipmap()`, `CompressedTexture3d::main_level()`,
                /// `CompressedTexture3dLayer::mipmap()` or `CompressedTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedTexture3d);

                impl<'a> ::std::ops::Deref for CompressedTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::srgb_texture3d::SrgbTexture3d;

        /// Contains the implementation of `SrgbTexture3d`.
        pub mod srgb_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing sRGB floating-point data.
pub struct SrgbTexture3d(TextureAny);

                impl GlObject for SrgbTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl SrgbTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<SrgbTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    SrgbTexture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<SrgbTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    SrgbTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: SrgbFormat, mipmaps: MipmapsOption)
                                          -> Result<SrgbTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    SrgbTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<SrgbFormat>, mipmaps: MipmapsOption)
                                   -> Result<SrgbTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnySrgb);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(SrgbTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<SrgbTexture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| SrgbTexture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<SrgbTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| SrgbTexture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<SrgbTexture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| SrgbTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture3dMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture3d`.
                ///
                /// Can be obtained by calling `SrgbTexture3d::mipmap()`, `SrgbTexture3d::main_level()`,
                /// `SrgbTexture3dLayer::mipmap()` or `SrgbTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture3d);

                impl<'a> ::std::ops::Deref for SrgbTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture3dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_srgb_texture3d::CompressedSrgbTexture3d;

        /// Contains the implementation of `CompressedSrgbTexture3d`.
        pub mod compressed_srgb_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A compressed three-dimensional texture  containing sRGB floating-point data.
pub struct CompressedSrgbTexture3d(TextureAny);

                impl GlObject for CompressedSrgbTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedSrgbTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedSrgbTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedSrgbTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedSrgbTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl CompressedSrgbTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedSrgbTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedSrgbTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<CompressedSrgbTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture3d::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedSrgbTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: &[u8], width: u32, height: u32, depth: u32,
                                                      format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedSrgbTexture3d, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedSrgbFormat(format);
                    Ok(CompressedSrgbTexture3d(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressedSrgb, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedSrgbTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<CompressedSrgbFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedSrgbTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressedSrgb);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedSrgbTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32, depth: u32) -> Result<CompressedSrgbTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| CompressedSrgbTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedSrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedSrgbTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedSrgbTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
                /// Reads the content of the texture to RAM without decompressing it before.
                ///
                /// You should avoid doing this at all cost during performance-critical
                /// operations (for example, while you're drawing).
                ///
                /// Returns the compressed format of the texture and the compressed data, gives
                /// `None` when the internal compression format is generic or unknown.
                #[inline]
                pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                    self.main_level().read_compressed_data()
                }
            
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture3dMipmap> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedSrgbTexture3d`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture3d::mipmap()`, `CompressedSrgbTexture3d::main_level()`,
                /// `CompressedSrgbTexture3dLayer::mipmap()` or `CompressedSrgbTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedSrgbTexture3d);

                impl<'a> ::std::ops::Deref for CompressedSrgbTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedSrgbTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                    /// Reads the content of the texture level to RAM without decompressing it before.
                    ///
                    /// You should avoid doing this at all cost during performance-critical
                    /// operations (for example, while you're drawing).
                    ///
                    /// Returns the compressed format of the texture and the compressed data, gives
                    /// `None` when the internal compression format is generic or unknown.
                    #[inline]
                    pub fn read_compressed_data(&self) -> Option<(CompressedSrgbFormat, Vec<u8>)> {
                        match self.0.download_compressed_data() {
                            Some((ClientFormatAny::CompressedSrgbFormat(format), buf)) => Some((format, buf)),
                            None => None,
                            _ => unreachable!(),
                        }
                    }
                
                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for CompressedSrgbTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }
}
pub use self::integral_texture3d::IntegralTexture3d;

        /// Contains the implementation of `IntegralTexture3d`.
        pub mod integral_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing signed integral data.
pub struct IntegralTexture3d(TextureAny);

                impl GlObject for IntegralTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl IntegralTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<IntegralTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    IntegralTexture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<IntegralTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    IntegralTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedIntFormat, mipmaps: MipmapsOption)
                                          -> Result<IntegralTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    IntegralTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedIntFormat>, mipmaps: MipmapsOption)
                                   -> Result<IntegralTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyIntegral);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(IntegralTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<IntegralTexture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| IntegralTexture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<IntegralTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| IntegralTexture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<IntegralTexture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| IntegralTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture3dMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture3d`.
                ///
                /// Can be obtained by calling `IntegralTexture3d::mipmap()`, `IntegralTexture3d::main_level()`,
                /// `IntegralTexture3dLayer::mipmap()` or `IntegralTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture3d);

                impl<'a> ::std::ops::Deref for IntegralTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture3dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture3d::UnsignedTexture3d;

        /// Contains the implementation of `UnsignedTexture3d`.
        pub mod unsigned_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing unsigned integral data.
pub struct UnsignedTexture3d(TextureAny);

                impl GlObject for UnsignedTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl UnsignedTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<UnsignedTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    UnsignedTexture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<UnsignedTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    UnsignedTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: UncompressedUintFormat, mipmaps: MipmapsOption)
                                          -> Result<UnsignedTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    UnsignedTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<UncompressedUintFormat>, mipmaps: MipmapsOption)
                                   -> Result<UnsignedTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyUnsigned);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(UnsignedTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<UnsignedTexture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| UnsignedTexture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<UnsignedTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| UnsignedTexture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<UnsignedTexture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| UnsignedTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture3dMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture3d`.
                ///
                /// Can be obtained by calling `UnsignedTexture3d::mipmap()`, `UnsignedTexture3d::main_level()`,
                /// `UnsignedTexture3dLayer::mipmap()` or `UnsignedTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture3d);

                impl<'a> ::std::ops::Deref for UnsignedTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture3dMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture3d::DepthTexture3d;

        /// Contains the implementation of `DepthTexture3d`.
        pub mod depth_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing depth data.
pub struct DepthTexture3d(TextureAny);

                impl GlObject for DepthTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture3d {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture3d(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture3d> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture3d(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture3d {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture3d> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl DepthTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthTexture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepth);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<DepthTexture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| DepthTexture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<DepthTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| DepthTexture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<DepthTexture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| DepthTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture3dMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture3d`.
                ///
                /// Can be obtained by calling `DepthTexture3d::mipmap()`, `DepthTexture3d::main_level()`,
                /// `DepthTexture3dLayer::mipmap()` or `DepthTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture3d);

                impl<'a> ::std::ops::Deref for DepthTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture3dMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture3d::DepthStencilTexture3d;

        /// Contains the implementation of `DepthStencilTexture3d`.
        pub mod depth_stencil_texture3d {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A three-dimensional texture  containing both depth and stencil data.
pub struct DepthStencilTexture3d(TextureAny);

                impl GlObject for DepthStencilTexture3d {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture3d {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture3d {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl DepthStencilTexture3d {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: T)
                              -> Result<DepthStencilTexture3d, TextureCreationError>
                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture3d::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: T, mipmaps: MipmapsOption)
                                              -> Result<DepthStencilTexture3d, TextureCreationError>
                                              where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture3d::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: T,
                                          format: DepthStencilFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthStencilTexture3d, TextureCreationError>
                                          where T: Texture3dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture3d::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: T,
                                   format: Option<DepthStencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthStencilTexture3d, TextureCreationError>
                                   where T: Texture3dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepthStencil);
                    let RawImage3d { data, width, height, depth, format: client_format } =
                                            data.into_raw();
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthStencilTexture3d(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, depth: u32)
                                -> Result<DepthStencilTexture3d, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| DepthStencilTexture3d(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<DepthStencilTexture3d, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth });
            t.map(|t| DepthStencilTexture3d(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, depth: u32) -> Result<DepthStencilTexture3d, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture3d { width: width, height: height, depth: depth }).map(|t| DepthStencilTexture3d(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture3d {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture3d(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture3dMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture3dMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture3dMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture3d`.
                ///
                /// Can be obtained by calling `DepthStencilTexture3d::mipmap()`, `DepthStencilTexture3d::main_level()`,
                /// `DepthStencilTexture3dLayer::mipmap()` or `DepthStencilTexture3dLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture3dMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture3d);

                impl<'a> ::std::ops::Deref for DepthStencilTexture3dMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture3dMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the depth of that image.
                #[inline]
                pub fn depth(&self) -> u32 {
                    self.0.get_depth().unwrap()
                }
            

                /// Returns the width, height and depth of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32, u32) {
                    (self.width(), self.height(), self.depth())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture3d {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        }
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture3dMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.first_layer().into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture3dMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture1d_array::Texture1dArray;

        /// Contains the implementation of `Texture1dArray`.
        pub mod texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing floating-point data.
pub struct Texture1dArray(TextureAny);

                impl GlObject for Texture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl Texture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl Texture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<Texture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<Texture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedFloatFormat, mipmaps: MipmapsOption)
                                          -> Result<Texture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    Texture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedFloatFormat>, mipmaps: MipmapsOption)
                                   -> Result<Texture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyFloatingPoint);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(Texture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<Texture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| Texture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<Texture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| Texture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<Texture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| Texture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> Texture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<Texture1dArrayLayer> {
                    self.0.layer(layer).map(|l| Texture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| Texture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `Texture1dArray`.
                ///
                /// Can be obtained by calling `Texture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct Texture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t Texture1dArray);
            impl<'t> Texture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| Texture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> Texture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture1dArray`.
                ///
                /// Can be obtained by calling `Texture1dArray::mipmap()`, `Texture1dArray::main_level()`,
                /// `Texture1dArrayLayer::mipmap()` or `Texture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture1dArray);

                impl<'a> ::std::ops::Deref for Texture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> Texture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<Texture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| Texture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `Texture1dArray`.
                #[derive(Copy, Clone)]
                pub struct Texture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t Texture1dArray);
            impl<'t> Texture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for Texture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_texture1d_array::CompressedTexture1dArray;

        /// Contains the implementation of `CompressedTexture1dArray`.
        pub mod compressed_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of compressed one-dimensional textures  containing floating-point data.
pub struct CompressedTexture1dArray(TextureAny);

                impl GlObject for CompressedTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl CompressedTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<CompressedTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1dArray::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: Vec<&[u8]>, width: u32, array_size: u32,
                                                      format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedTexture1dArray, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedFormat(format);
                    Ok(CompressedTexture1dArray(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressed, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<CompressedFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressed);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedFormat, mipmaps: CompressedMipmapsOption, width: u32, array_size: u32) -> Result<CompressedTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| CompressedTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> CompressedTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<CompressedTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| CompressedTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| CompressedTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `CompressedTexture1dArray`.
                ///
                /// Can be obtained by calling `CompressedTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t CompressedTexture1dArray);
            impl<'t> CompressedTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| CompressedTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedTexture1dArray`.
                ///
                /// Can be obtained by calling `CompressedTexture1dArray::mipmap()`, `CompressedTexture1dArray::main_level()`,
                /// `CompressedTexture1dArrayLayer::mipmap()` or `CompressedTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedTexture1dArray);

                impl<'a> ::std::ops::Deref for CompressedTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> CompressedTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<CompressedTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| CompressedTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `CompressedTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t CompressedTexture1dArray);
            impl<'t> CompressedTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for CompressedTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }
}
pub use self::srgb_texture1d_array::SrgbTexture1dArray;

        /// Contains the implementation of `SrgbTexture1dArray`.
        pub mod srgb_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing sRGB floating-point data.
pub struct SrgbTexture1dArray(TextureAny);

                impl GlObject for SrgbTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl SrgbTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<SrgbTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<SrgbTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: SrgbFormat, mipmaps: MipmapsOption)
                                          -> Result<SrgbTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    SrgbTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<SrgbFormat>, mipmaps: MipmapsOption)
                                   -> Result<SrgbTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnySrgb);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(SrgbTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<SrgbTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| SrgbTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<SrgbTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| SrgbTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<SrgbTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| SrgbTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> SrgbTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<SrgbTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| SrgbTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `SrgbTexture1dArray`.
                ///
                /// Can be obtained by calling `SrgbTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t SrgbTexture1dArray);
            impl<'t> SrgbTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| SrgbTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture1dArray`.
                ///
                /// Can be obtained by calling `SrgbTexture1dArray::mipmap()`, `SrgbTexture1dArray::main_level()`,
                /// `SrgbTexture1dArrayLayer::mipmap()` or `SrgbTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture1dArray);

                impl<'a> ::std::ops::Deref for SrgbTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> SrgbTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<SrgbTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| SrgbTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `SrgbTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t SrgbTexture1dArray);
            impl<'t> SrgbTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_srgb_texture1d_array::CompressedSrgbTexture1dArray;

        /// Contains the implementation of `CompressedSrgbTexture1dArray`.
        pub mod compressed_srgb_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of compressed one-dimensional textures  containing sRGB floating-point data.
pub struct CompressedSrgbTexture1dArray(TextureAny);

                impl GlObject for CompressedSrgbTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedSrgbTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedSrgbTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedSrgbTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedSrgbTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl CompressedSrgbTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedSrgbTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedSrgbTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<CompressedSrgbTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1dArray::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedSrgbTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: Vec<&[u8]>, width: u32, array_size: u32,
                                                      format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedSrgbTexture1dArray, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedSrgbFormat(format);
                    Ok(CompressedSrgbTexture1dArray(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressedSrgb, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedSrgbTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<CompressedSrgbFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedSrgbTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressedSrgb);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedSrgbTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption, width: u32, array_size: u32) -> Result<CompressedSrgbTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| CompressedSrgbTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedSrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedSrgbTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedSrgbTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> CompressedSrgbTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<CompressedSrgbTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| CompressedSrgbTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `CompressedSrgbTexture1dArray`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t CompressedSrgbTexture1dArray);
            impl<'t> CompressedSrgbTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedSrgbTexture1dArray`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture1dArray::mipmap()`, `CompressedSrgbTexture1dArray::main_level()`,
                /// `CompressedSrgbTexture1dArrayLayer::mipmap()` or `CompressedSrgbTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedSrgbTexture1dArray);

                impl<'a> ::std::ops::Deref for CompressedSrgbTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedSrgbTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> CompressedSrgbTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<CompressedSrgbTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| CompressedSrgbTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `CompressedSrgbTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t CompressedSrgbTexture1dArray);
            impl<'t> CompressedSrgbTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for CompressedSrgbTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }
}
pub use self::integral_texture1d_array::IntegralTexture1dArray;

        /// Contains the implementation of `IntegralTexture1dArray`.
        pub mod integral_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing signed integral data.
pub struct IntegralTexture1dArray(TextureAny);

                impl GlObject for IntegralTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl IntegralTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<IntegralTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<IntegralTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedIntFormat, mipmaps: MipmapsOption)
                                          -> Result<IntegralTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    IntegralTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedIntFormat>, mipmaps: MipmapsOption)
                                   -> Result<IntegralTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyIntegral);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(IntegralTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<IntegralTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| IntegralTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<IntegralTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| IntegralTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<IntegralTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| IntegralTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> IntegralTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<IntegralTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| IntegralTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `IntegralTexture1dArray`.
                ///
                /// Can be obtained by calling `IntegralTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t IntegralTexture1dArray);
            impl<'t> IntegralTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| IntegralTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture1dArray`.
                ///
                /// Can be obtained by calling `IntegralTexture1dArray::mipmap()`, `IntegralTexture1dArray::main_level()`,
                /// `IntegralTexture1dArrayLayer::mipmap()` or `IntegralTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture1dArray);

                impl<'a> ::std::ops::Deref for IntegralTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> IntegralTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<IntegralTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| IntegralTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `IntegralTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t IntegralTexture1dArray);
            impl<'t> IntegralTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture1d_array::UnsignedTexture1dArray;

        /// Contains the implementation of `UnsignedTexture1dArray`.
        pub mod unsigned_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing unsigned integral data.
pub struct UnsignedTexture1dArray(TextureAny);

                impl GlObject for UnsignedTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl UnsignedTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<UnsignedTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<UnsignedTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedUintFormat, mipmaps: MipmapsOption)
                                          -> Result<UnsignedTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    UnsignedTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedUintFormat>, mipmaps: MipmapsOption)
                                   -> Result<UnsignedTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyUnsigned);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(UnsignedTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<UnsignedTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| UnsignedTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<UnsignedTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| UnsignedTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<UnsignedTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| UnsignedTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> UnsignedTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<UnsignedTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| UnsignedTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `UnsignedTexture1dArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t UnsignedTexture1dArray);
            impl<'t> UnsignedTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| UnsignedTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture1dArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture1dArray::mipmap()`, `UnsignedTexture1dArray::main_level()`,
                /// `UnsignedTexture1dArrayLayer::mipmap()` or `UnsignedTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture1dArray);

                impl<'a> ::std::ops::Deref for UnsignedTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> UnsignedTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<UnsignedTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| UnsignedTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `UnsignedTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t UnsignedTexture1dArray);
            impl<'t> UnsignedTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture1d_array::DepthTexture1dArray;

        /// Contains the implementation of `DepthTexture1dArray`.
        pub mod depth_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing depth data.
pub struct DepthTexture1dArray(TextureAny);

                impl GlObject for DepthTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture1dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture1dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture1dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture1dArray(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture1dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture1dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl DepthTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<DepthTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<DepthTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: DepthFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<DepthFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepth);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<DepthTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| DepthTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<DepthTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| DepthTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<DepthTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| DepthTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| DepthTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthTexture1dArray`.
                ///
                /// Can be obtained by calling `DepthTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthTexture1dArray);
            impl<'t> DepthTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture1dArray`.
                ///
                /// Can be obtained by calling `DepthTexture1dArray::mipmap()`, `DepthTexture1dArray::main_level()`,
                /// `DepthTexture1dArrayLayer::mipmap()` or `DepthTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture1dArray);

                impl<'a> ::std::ops::Deref for DepthTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthTexture1dArray);
            impl<'t> DepthTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture1d_array::StencilTexture1dArray;

        /// Contains the implementation of `StencilTexture1dArray`.
        pub mod stencil_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing stencil data.
pub struct StencilTexture1dArray(TextureAny);

                impl GlObject for StencilTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl StencilTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<StencilTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<StencilTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: StencilFormat, mipmaps: MipmapsOption)
                                          -> Result<StencilTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    StencilTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<StencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<StencilTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyStencil);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(StencilTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<StencilTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| StencilTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<StencilTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| StencilTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<StencilTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| StencilTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> StencilTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<StencilTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| StencilTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `StencilTexture1dArray`.
                ///
                /// Can be obtained by calling `StencilTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t StencilTexture1dArray);
            impl<'t> StencilTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| StencilTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> StencilTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture1dArray`.
                ///
                /// Can be obtained by calling `StencilTexture1dArray::mipmap()`, `StencilTexture1dArray::main_level()`,
                /// `StencilTexture1dArrayLayer::mipmap()` or `StencilTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture1dArray);

                impl<'a> ::std::ops::Deref for StencilTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> StencilTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<StencilTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| StencilTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `StencilTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t StencilTexture1dArray);
            impl<'t> StencilTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture1d_array::DepthStencilTexture1dArray;

        /// Contains the implementation of `DepthStencilTexture1dArray`.
        pub mod depth_stencil_texture1d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of one-dimensional textures  containing both depth and stencil data.
pub struct DepthStencilTexture1dArray(TextureAny);

                impl GlObject for DepthStencilTexture1dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture1dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture1dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl DepthStencilTexture1dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<DepthStencilTexture1dArray, TextureCreationError>
                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<DepthStencilTexture1dArray, TextureCreationError>
                                              where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: DepthStencilFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthStencilTexture1dArray, TextureCreationError>
                                          where T: Texture1dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture1dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<DepthStencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthStencilTexture1dArray, TextureCreationError>
                                   where T: Texture1dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepthStencil);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage2d {data, width, height: array_size, format: client_format } = RawImage2d::from_vec_raw1d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthStencilTexture1dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, array_size: u32)
                                -> Result<DepthStencilTexture1dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| DepthStencilTexture1dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<DepthStencilTexture1dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size });
            t.map(|t| DepthStencilTexture1dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, array_size: u32) -> Result<DepthStencilTexture1dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture1dArray { width: width, array_size: array_size }).map(|t| DepthStencilTexture1dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture1dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture1dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthStencilTexture1dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture1dArrayLayer> {
                    self.0.layer(layer).map(|l| DepthStencilTexture1dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture1dArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture1dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture1dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthStencilTexture1dArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture1dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture1dArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthStencilTexture1dArray);
            impl<'t> DepthStencilTexture1dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture1dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture1dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthStencilTexture1dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture1dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture1dArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture1dArray::mipmap()`, `DepthStencilTexture1dArray::main_level()`,
                /// `DepthStencilTexture1dArrayLayer::mipmap()` or `DepthStencilTexture1dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture1dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture1dArray);

                impl<'a> ::std::ops::Deref for DepthStencilTexture1dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture1dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture1dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthStencilTexture1dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture1dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthStencilTexture1dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthStencilTexture1dArray`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture1dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthStencilTexture1dArray);
            impl<'t> DepthStencilTexture1dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    
}
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture1dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture1dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture2d_array::Texture2dArray;

        /// Contains the implementation of `Texture2dArray`.
        pub mod texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing floating-point data.
pub struct Texture2dArray(TextureAny);

                impl GlObject for Texture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl Texture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl Texture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<Texture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<Texture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedFloatFormat, mipmaps: MipmapsOption)
                                          -> Result<Texture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    Texture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedFloatFormat>, mipmaps: MipmapsOption)
                                   -> Result<Texture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyFloatingPoint);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(Texture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<Texture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| Texture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<Texture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| Texture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<Texture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| Texture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> Texture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<Texture2dArrayLayer> {
                    self.0.layer(layer).map(|l| Texture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| Texture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `Texture2dArray`.
                ///
                /// Can be obtained by calling `Texture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t Texture2dArray);
            impl<'t> Texture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| Texture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> Texture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture2dArray`.
                ///
                /// Can be obtained by calling `Texture2dArray::mipmap()`, `Texture2dArray::main_level()`,
                /// `Texture2dArrayLayer::mipmap()` or `Texture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture2dArray);

                impl<'a> ::std::ops::Deref for Texture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> Texture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<Texture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| Texture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `Texture2dArray`.
                #[derive(Copy, Clone)]
                pub struct Texture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t Texture2dArray);
            impl<'t> Texture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for Texture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_texture2d_array::CompressedTexture2dArray;

        /// Contains the implementation of `CompressedTexture2dArray`.
        pub mod compressed_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of compressed two-dimensional textures  containing floating-point data.
pub struct CompressedTexture2dArray(TextureAny);

                impl GlObject for CompressedTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl CompressedTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<CompressedTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2dArray::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: Vec<&[u8]>, width: u32, height: u32, array_size: u32,
                                                      format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedTexture2dArray, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedFormat(format);
                    Ok(CompressedTexture2dArray(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressed, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: CompressedFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<CompressedFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressed);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32, array_size: u32) -> Result<CompressedTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| CompressedTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> CompressedTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<CompressedTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| CompressedTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| CompressedTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `CompressedTexture2dArray`.
                ///
                /// Can be obtained by calling `CompressedTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t CompressedTexture2dArray);
            impl<'t> CompressedTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| CompressedTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> CompressedTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedTexture2dArray`.
                ///
                /// Can be obtained by calling `CompressedTexture2dArray::mipmap()`, `CompressedTexture2dArray::main_level()`,
                /// `CompressedTexture2dArrayLayer::mipmap()` or `CompressedTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedTexture2dArray);

                impl<'a> ::std::ops::Deref for CompressedTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> CompressedTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<CompressedTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| CompressedTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `CompressedTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct CompressedTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t CompressedTexture2dArray);
            impl<'t> CompressedTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for CompressedTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }
}
pub use self::srgb_texture2d_array::SrgbTexture2dArray;

        /// Contains the implementation of `SrgbTexture2dArray`.
        pub mod srgb_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing sRGB floating-point data.
pub struct SrgbTexture2dArray(TextureAny);

                impl GlObject for SrgbTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl SrgbTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<SrgbTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<SrgbTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: SrgbFormat, mipmaps: MipmapsOption)
                                          -> Result<SrgbTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    SrgbTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<SrgbFormat>, mipmaps: MipmapsOption)
                                   -> Result<SrgbTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnySrgb);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(SrgbTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<SrgbTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| SrgbTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<SrgbTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| SrgbTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<SrgbTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| SrgbTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> SrgbTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<SrgbTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| SrgbTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `SrgbTexture2dArray`.
                ///
                /// Can be obtained by calling `SrgbTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t SrgbTexture2dArray);
            impl<'t> SrgbTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| SrgbTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture2dArray`.
                ///
                /// Can be obtained by calling `SrgbTexture2dArray::mipmap()`, `SrgbTexture2dArray::main_level()`,
                /// `SrgbTexture2dArrayLayer::mipmap()` or `SrgbTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture2dArray);

                impl<'a> ::std::ops::Deref for SrgbTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> SrgbTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<SrgbTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| SrgbTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `SrgbTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t SrgbTexture2dArray);
            impl<'t> SrgbTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_srgb_texture2d_array::CompressedSrgbTexture2dArray;

        /// Contains the implementation of `CompressedSrgbTexture2dArray`.
        pub mod compressed_srgb_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of compressed two-dimensional textures  containing sRGB floating-point data.
pub struct CompressedSrgbTexture2dArray(TextureAny);

                impl GlObject for CompressedSrgbTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for CompressedSrgbTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for CompressedSrgbTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a CompressedSrgbTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, CompressedSrgbTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::CompressedSrgbTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl CompressedSrgbTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<CompressedSrgbTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl CompressedSrgbTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// No mipmap level (except for the main level) will be allocator nor generated.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<CompressedSrgbTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2dArray::new_impl(facade, data, None, CompressedMipmapsOption::NoMipmap)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: CompressedMipmapsOption)
                                              -> Result<CompressedSrgbTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format. The input data must also be of the
                /// specified compressed format.
                #[inline]
                pub fn with_compressed_data<F: ?Sized>(facade: &F, data: Vec<&[u8]>, width: u32, height: u32, array_size: u32,
                                                      format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                                      -> Result<CompressedSrgbTexture2dArray, TextureCreationError>
                                                       where F: Facade
                {
                    let data = Cow::Borrowed(data.as_ref());
                    let client_format = ClientFormatAny::CompressedSrgbFormat(format);
                    Ok(CompressedSrgbTexture2dArray(try!(any::new_texture(facade, TextureFormatRequest::AnyCompressedSrgb, Some((client_format, data)),
                                                    mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption)
                                          -> Result<CompressedSrgbTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    CompressedSrgbTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<CompressedSrgbFormat>, mipmaps: CompressedMipmapsOption)
                                   -> Result<CompressedSrgbTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyCompressedSrgb);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(CompressedSrgbTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: CompressedSrgbFormat, mipmaps: CompressedMipmapsOption, width: u32, height: u32, array_size: u32) -> Result<CompressedSrgbTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| CompressedSrgbTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: CompressedSrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> CompressedSrgbTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    CompressedSrgbTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> CompressedSrgbTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<CompressedSrgbTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| CompressedSrgbTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `CompressedSrgbTexture2dArray`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t CompressedSrgbTexture2dArray);
            impl<'t> CompressedSrgbTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CompressedSrgbTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| CompressedSrgbTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> CompressedSrgbTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `CompressedSrgbTexture2dArray`.
                ///
                /// Can be obtained by calling `CompressedSrgbTexture2dArray::mipmap()`, `CompressedSrgbTexture2dArray::main_level()`,
                /// `CompressedSrgbTexture2dArrayLayer::mipmap()` or `CompressedSrgbTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t CompressedSrgbTexture2dArray);

                impl<'a> ::std::ops::Deref for CompressedSrgbTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CompressedSrgbTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t CompressedSrgbTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> CompressedSrgbTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<CompressedSrgbTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| CompressedSrgbTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `CompressedSrgbTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct CompressedSrgbTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t CompressedSrgbTexture2dArray);
            impl<'t> CompressedSrgbTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for CompressedSrgbTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }
}
pub use self::integral_texture2d_array::IntegralTexture2dArray;

        /// Contains the implementation of `IntegralTexture2dArray`.
        pub mod integral_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing signed integral data.
pub struct IntegralTexture2dArray(TextureAny);

                impl GlObject for IntegralTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl IntegralTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<IntegralTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<IntegralTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedIntFormat, mipmaps: MipmapsOption)
                                          -> Result<IntegralTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    IntegralTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedIntFormat>, mipmaps: MipmapsOption)
                                   -> Result<IntegralTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyIntegral);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(IntegralTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<IntegralTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| IntegralTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<IntegralTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| IntegralTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<IntegralTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| IntegralTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> IntegralTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<IntegralTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| IntegralTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `IntegralTexture2dArray`.
                ///
                /// Can be obtained by calling `IntegralTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t IntegralTexture2dArray);
            impl<'t> IntegralTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| IntegralTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture2dArray`.
                ///
                /// Can be obtained by calling `IntegralTexture2dArray::mipmap()`, `IntegralTexture2dArray::main_level()`,
                /// `IntegralTexture2dArrayLayer::mipmap()` or `IntegralTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture2dArray);

                impl<'a> ::std::ops::Deref for IntegralTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> IntegralTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<IntegralTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| IntegralTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `IntegralTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t IntegralTexture2dArray);
            impl<'t> IntegralTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture2d_array::UnsignedTexture2dArray;

        /// Contains the implementation of `UnsignedTexture2dArray`.
        pub mod unsigned_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing unsigned integral data.
pub struct UnsignedTexture2dArray(TextureAny);

                impl GlObject for UnsignedTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl UnsignedTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<UnsignedTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<UnsignedTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: UncompressedUintFormat, mipmaps: MipmapsOption)
                                          -> Result<UnsignedTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    UnsignedTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<UncompressedUintFormat>, mipmaps: MipmapsOption)
                                   -> Result<UnsignedTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyUnsigned);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(UnsignedTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<UnsignedTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| UnsignedTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<UnsignedTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| UnsignedTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<UnsignedTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| UnsignedTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> UnsignedTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<UnsignedTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| UnsignedTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `UnsignedTexture2dArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t UnsignedTexture2dArray);
            impl<'t> UnsignedTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture2dArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture2dArray::mipmap()`, `UnsignedTexture2dArray::main_level()`,
                /// `UnsignedTexture2dArrayLayer::mipmap()` or `UnsignedTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture2dArray);

                impl<'a> ::std::ops::Deref for UnsignedTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> UnsignedTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<UnsignedTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| UnsignedTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `UnsignedTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t UnsignedTexture2dArray);
            impl<'t> UnsignedTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture2d_array::DepthTexture2dArray;

        /// Contains the implementation of `DepthTexture2dArray`.
        pub mod depth_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing depth data.
pub struct DepthTexture2dArray(TextureAny);

                impl GlObject for DepthTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture2dArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture2dArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dArray(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture2dArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture2dArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl DepthTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<DepthTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<DepthTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: DepthFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<DepthFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepth);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<DepthTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| DepthTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<DepthTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| DepthTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<DepthTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| DepthTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| DepthTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthTexture2dArray`.
                ///
                /// Can be obtained by calling `DepthTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthTexture2dArray);
            impl<'t> DepthTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture2dArray`.
                ///
                /// Can be obtained by calling `DepthTexture2dArray::mipmap()`, `DepthTexture2dArray::main_level()`,
                /// `DepthTexture2dArrayLayer::mipmap()` or `DepthTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture2dArray);

                impl<'a> ::std::ops::Deref for DepthTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthTexture2dArray);
            impl<'t> DepthTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture2d_array::StencilTexture2dArray;

        /// Contains the implementation of `StencilTexture2dArray`.
        pub mod stencil_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing stencil data.
pub struct StencilTexture2dArray(TextureAny);

                impl GlObject for StencilTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl StencilTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<StencilTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<StencilTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: StencilFormat, mipmaps: MipmapsOption)
                                          -> Result<StencilTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    StencilTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<StencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<StencilTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyStencil);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(StencilTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<StencilTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| StencilTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<StencilTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| StencilTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<StencilTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| StencilTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> StencilTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<StencilTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| StencilTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `StencilTexture2dArray`.
                ///
                /// Can be obtained by calling `StencilTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t StencilTexture2dArray);
            impl<'t> StencilTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| StencilTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture2dArray`.
                ///
                /// Can be obtained by calling `StencilTexture2dArray::mipmap()`, `StencilTexture2dArray::main_level()`,
                /// `StencilTexture2dArrayLayer::mipmap()` or `StencilTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture2dArray);

                impl<'a> ::std::ops::Deref for StencilTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> StencilTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<StencilTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| StencilTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `StencilTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t StencilTexture2dArray);
            impl<'t> StencilTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture2d_array::DepthStencilTexture2dArray;

        /// Contains the implementation of `DepthStencilTexture2dArray`.
        pub mod depth_stencil_texture2d_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing both depth and stencil data.
pub struct DepthStencilTexture2dArray(TextureAny);

                impl GlObject for DepthStencilTexture2dArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture2dArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture2dArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl DepthStencilTexture2dArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Builds a new texture by uploading data.
                ///
                /// This function will automatically generate all mipmaps of the texture.
                #[inline]
                pub fn new<'a, F: ?Sized, T>(facade: &F, data: Vec<T>)
                              -> Result<DepthStencilTexture2dArray, TextureCreationError>
                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2dArray::new_impl(facade, data, None, MipmapsOption::AutoGeneratedMipmaps)
                }
            

                /// Builds a new texture by uploading data.
                #[inline]
                pub fn with_mipmaps<'a, F: ?Sized, T>(facade: &F, data: Vec<T>, mipmaps: MipmapsOption)
                                              -> Result<DepthStencilTexture2dArray, TextureCreationError>
                                              where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2dArray::new_impl(facade, data, None, mipmaps)
                }
            

                /// Builds a new texture with a specific format.
                #[inline]
                pub fn with_format<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                          format: DepthStencilFormat, mipmaps: MipmapsOption)
                                          -> Result<DepthStencilTexture2dArray, TextureCreationError>
                                          where T: Texture2dDataSource<'a>, F: Facade
                {
                    DepthStencilTexture2dArray::new_impl(facade, data, Some(format), mipmaps)
                }
            

                #[inline]
                fn new_impl<'a, F: ?Sized, T>(facade: &F, data: Vec<T>,
                                   format: Option<DepthStencilFormat>, mipmaps: MipmapsOption)
                                   -> Result<DepthStencilTexture2dArray, TextureCreationError>
                                   where T: Texture2dDataSource<'a>, F: Facade
                {
            
let format = format.map(|f| {
                           TextureFormatRequest::Specific(f.to_texture_format())
                       }).unwrap_or(TextureFormatRequest::AnyDepthStencil);
                    let vec_raw = data.into_iter().map(|e| e.into_raw()).collect();
                    let RawImage3d {data, width, height, depth: array_size, format: client_format } = RawImage3d::from_vec_raw2d(&vec_raw);
                let client_format = ClientFormatAny::ClientFormat(client_format);Ok(DepthStencilTexture2dArray(try!(any::new_texture(facade, format, Some((client_format, data)), mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }))))
}

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32)
                                -> Result<DepthStencilTexture2dArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| DepthStencilTexture2dArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<DepthStencilTexture2dArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size });
            t.map(|t| DepthStencilTexture2dArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32) -> Result<DepthStencilTexture2dArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dArray { width: width, height: height, array_size: array_size }).map(|t| DepthStencilTexture2dArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture2dArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture2dArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthStencilTexture2dArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture2dArrayLayer> {
                    self.0.layer(layer).map(|l| DepthStencilTexture2dArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthStencilTexture2dArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2dArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthStencilTexture2dArray);
            impl<'t> DepthStencilTexture2dArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2dArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture2dArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2dArray::mipmap()`, `DepthStencilTexture2dArray::main_level()`,
                /// `DepthStencilTexture2dArrayLayer::mipmap()` or `DepthStencilTexture2dArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture2dArray);

                impl<'a> ::std::ops::Deref for DepthStencilTexture2dArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture2dArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2dArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthStencilTexture2dArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture2dArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthStencilTexture2dArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthStencilTexture2dArray`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthStencilTexture2dArray);
            impl<'t> DepthStencilTexture2dArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture2dArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture2dArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::texture2d_multisample_array::Texture2dMultisampleArray;

        /// Contains the implementation of `Texture2dMultisampleArray`.
        pub mod texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing floating-point data.
pub struct Texture2dMultisampleArray(TextureAny);

                impl GlObject for Texture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Texture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Texture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Texture2dMultisampleArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dMultisampleArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Texture2dMultisampleArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Texture2dMultisampleArray(self.0, Some(self.1))
                                }
                            }

                            impl Texture2dMultisampleArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Texture2dMultisampleArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl Texture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<Texture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| Texture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<Texture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| Texture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<Texture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| Texture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Texture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Texture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> Texture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<Texture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| Texture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| Texture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> Texture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `Texture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `Texture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t Texture2dMultisampleArray);
            impl<'t> Texture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<Texture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| Texture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> Texture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Texture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `Texture2dMultisampleArray::mipmap()`, `Texture2dMultisampleArray::main_level()`,
                /// `Texture2dMultisampleArrayLayer::mipmap()` or `Texture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct Texture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t Texture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for Texture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> Texture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Texture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> Texture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<Texture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| Texture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `Texture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct Texture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t Texture2dMultisampleArray);
            impl<'t> Texture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for Texture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for Texture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::srgb_texture2d_multisample_array::SrgbTexture2dMultisampleArray;

        /// Contains the implementation of `SrgbTexture2dMultisampleArray`.
        pub mod srgb_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing sRGB floating-point data.
pub struct SrgbTexture2dMultisampleArray(TextureAny);

                impl GlObject for SrgbTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for SrgbTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for SrgbTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a SrgbTexture2dMultisampleArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dMultisampleArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, SrgbTexture2dMultisampleArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::SrgbTexture2dMultisampleArray(self.0, Some(self.1))
                                }
                            }

                            impl SrgbTexture2dMultisampleArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<SrgbTexture2dMultisampleArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl SrgbTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<SrgbTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| SrgbTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: SrgbFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<SrgbTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| SrgbTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<SrgbTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnySrgb;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| SrgbTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: SrgbFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> SrgbTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    SrgbTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> SrgbTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<SrgbTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| SrgbTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| SrgbTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `SrgbTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `SrgbTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t SrgbTexture2dMultisampleArray);
            impl<'t> SrgbTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<SrgbTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| SrgbTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> SrgbTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `SrgbTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `SrgbTexture2dMultisampleArray::mipmap()`, `SrgbTexture2dMultisampleArray::main_level()`,
                /// `SrgbTexture2dMultisampleArrayLayer::mipmap()` or `SrgbTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t SrgbTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for SrgbTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> SrgbTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t SrgbTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> SrgbTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<SrgbTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| SrgbTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `SrgbTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct SrgbTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t SrgbTexture2dMultisampleArray);
            impl<'t> SrgbTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for SrgbTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for SrgbTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::integral_texture2d_multisample_array::IntegralTexture2dMultisampleArray;

        /// Contains the implementation of `IntegralTexture2dMultisampleArray`.
        pub mod integral_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing signed integral data.
pub struct IntegralTexture2dMultisampleArray(TextureAny);

                impl GlObject for IntegralTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for IntegralTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for IntegralTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a IntegralTexture2dMultisampleArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dMultisampleArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, IntegralTexture2dMultisampleArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::IntegralTexture2dMultisampleArray(self.0, Some(self.1))
                                }
                            }

                            impl IntegralTexture2dMultisampleArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<IntegralTexture2dMultisampleArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl IntegralTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<IntegralTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| IntegralTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedIntFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<IntegralTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| IntegralTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<IntegralTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyIntegral;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| IntegralTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedIntFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> IntegralTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    IntegralTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> IntegralTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<IntegralTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| IntegralTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| IntegralTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `IntegralTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `IntegralTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t IntegralTexture2dMultisampleArray);
            impl<'t> IntegralTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<IntegralTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| IntegralTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> IntegralTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `IntegralTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `IntegralTexture2dMultisampleArray::mipmap()`, `IntegralTexture2dMultisampleArray::main_level()`,
                /// `IntegralTexture2dMultisampleArrayLayer::mipmap()` or `IntegralTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t IntegralTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for IntegralTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> IntegralTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t IntegralTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> IntegralTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<IntegralTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| IntegralTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `IntegralTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct IntegralTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t IntegralTexture2dMultisampleArray);
            impl<'t> IntegralTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for IntegralTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for IntegralTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::unsigned_texture2d_multisample_array::UnsignedTexture2dMultisampleArray;

        /// Contains the implementation of `UnsignedTexture2dMultisampleArray`.
        pub mod unsigned_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing unsigned integral data.
pub struct UnsignedTexture2dMultisampleArray(TextureAny);

                impl GlObject for UnsignedTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for UnsignedTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for UnsignedTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a UnsignedTexture2dMultisampleArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dMultisampleArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, UnsignedTexture2dMultisampleArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::UnsignedTexture2dMultisampleArray(self.0, Some(self.1))
                                }
                            }

                            impl UnsignedTexture2dMultisampleArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<UnsignedTexture2dMultisampleArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl UnsignedTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<UnsignedTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| UnsignedTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedUintFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<UnsignedTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| UnsignedTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<UnsignedTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyUnsigned;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| UnsignedTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedUintFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> UnsignedTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    UnsignedTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> UnsignedTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<UnsignedTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| UnsignedTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `UnsignedTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t UnsignedTexture2dMultisampleArray);
            impl<'t> UnsignedTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<UnsignedTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| UnsignedTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> UnsignedTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `UnsignedTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `UnsignedTexture2dMultisampleArray::mipmap()`, `UnsignedTexture2dMultisampleArray::main_level()`,
                /// `UnsignedTexture2dMultisampleArrayLayer::mipmap()` or `UnsignedTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t UnsignedTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for UnsignedTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> UnsignedTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t UnsignedTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> UnsignedTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<UnsignedTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| UnsignedTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `UnsignedTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct UnsignedTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t UnsignedTexture2dMultisampleArray);
            impl<'t> UnsignedTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for UnsignedTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for UnsignedTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_texture2d_multisample_array::DepthTexture2dMultisampleArray;

        /// Contains the implementation of `DepthTexture2dMultisampleArray`.
        pub mod depth_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing depth data.
pub struct DepthTexture2dMultisampleArray(TextureAny);

                impl GlObject for DepthTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a DepthTexture2dMultisampleArray {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dMultisampleArray(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, DepthTexture2dMultisampleArray> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::DepthTexture2dMultisampleArray(self.0, Some(self.1))
                                }
                            }

                            impl DepthTexture2dMultisampleArray {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<DepthTexture2dMultisampleArray> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl DepthTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<DepthTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| DepthTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<DepthTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| DepthTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<DepthTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepth;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| DepthTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| DepthTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `DepthTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthTexture2dMultisampleArray);
            impl<'t> DepthTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `DepthTexture2dMultisampleArray::mipmap()`, `DepthTexture2dMultisampleArray::main_level()`,
                /// `DepthTexture2dMultisampleArrayLayer::mipmap()` or `DepthTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for DepthTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct DepthTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthTexture2dMultisampleArray);
            impl<'t> DepthTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for DepthTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthAttachment<'t> for DepthTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_attachment(self) -> ::framebuffer::DepthAttachment<'t> {
                                ::framebuffer::DepthAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::stencil_texture2d_multisample_array::StencilTexture2dMultisampleArray;

        /// Contains the implementation of `StencilTexture2dMultisampleArray`.
        pub mod stencil_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing stencil data.
pub struct StencilTexture2dMultisampleArray(TextureAny);

                impl GlObject for StencilTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for StencilTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for StencilTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl StencilTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<StencilTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| StencilTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: StencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<StencilTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| StencilTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<StencilTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| StencilTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: StencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> StencilTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    StencilTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> StencilTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<StencilTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| StencilTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| StencilTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `StencilTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `StencilTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t StencilTexture2dMultisampleArray);
            impl<'t> StencilTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<StencilTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| StencilTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> StencilTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `StencilTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `StencilTexture2dMultisampleArray::mipmap()`, `StencilTexture2dMultisampleArray::main_level()`,
                /// `StencilTexture2dMultisampleArrayLayer::mipmap()` or `StencilTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t StencilTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for StencilTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> StencilTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t StencilTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> StencilTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<StencilTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| StencilTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `StencilTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct StencilTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t StencilTexture2dMultisampleArray);
            impl<'t> StencilTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for StencilTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToStencilAttachment<'t> for StencilTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_stencil_attachment(self) -> ::framebuffer::StencilAttachment<'t> {
                                ::framebuffer::StencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::depth_stencil_texture2d_multisample_array::DepthStencilTexture2dMultisampleArray;

        /// Contains the implementation of `DepthStencilTexture2dMultisampleArray`.
        pub mod depth_stencil_texture2d_multisample_array {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// An array of two-dimensional textures  containing both depth and stencil data.
pub struct DepthStencilTexture2dMultisampleArray(TextureAny);

                impl GlObject for DepthStencilTexture2dMultisampleArray {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for DepthStencilTexture2dMultisampleArray {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for DepthStencilTexture2dMultisampleArray {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            
impl DepthStencilTexture2dMultisampleArray {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, width: u32, height: u32, array_size: u32, samples: u32)
                                -> Result<DepthStencilTexture2dMultisampleArray, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| DepthStencilTexture2dMultisampleArray(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: DepthStencilFormat, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<DepthStencilTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples });
            t.map(|t| DepthStencilTexture2dMultisampleArray(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, width: u32, height: u32, array_size: u32, samples: u32) -> Result<DepthStencilTexture2dMultisampleArray, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyDepthStencil;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Texture2dMultisampleArray { width: width, height: height, array_size: array_size, samples: samples }).map(|t| DepthStencilTexture2dMultisampleArray(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: DepthStencilFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> DepthStencilTexture2dMultisampleArray {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    DepthStencilTexture2dMultisampleArray(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
                /// Access the first layer of this texture.
                #[inline]
                pub fn first_layer(&self) -> DepthStencilTexture2dMultisampleArrayLayer {
                    self.layer(0).unwrap()
                }

                /// Access a single layer of this texture.
                #[inline]
                pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture2dMultisampleArrayLayer> {
                    self.0.layer(layer).map(|l| DepthStencilTexture2dMultisampleArrayLayer(l, self))
                }
            
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dMultisampleArrayMipmap> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dMultisampleArrayMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dMultisampleArrayMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single layer of a `DepthStencilTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2dMultisampleArray::layer()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dMultisampleArrayLayer<'t>(TextureAnyLayer<'t>, &'t DepthStencilTexture2dMultisampleArray);
            impl<'t> DepthStencilTexture2dMultisampleArrayLayer<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            (self.1).0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    (self.1).0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    (self.1).0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2dMultisampleArray {
                    &self.1
                }

                /// Returns the layer index.
                #[inline]
                pub fn get_layer(&self) -> u32 {
                    self.0.get_layer()
                }
            
                /// Returns the number of mipmap levels of the texture.
                ///
                /// The minimum value is 1, since there is always a main texture.
                #[inline]
                pub fn get_mipmap_levels(&self) -> u32 {
                    self.0.get_texture().get_mipmap_levels()
                }
            
            /// Access a single mipmap level of this layer.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<DepthStencilTexture2dMultisampleArrayLayerMipmap<'t>> {
                self.0.mipmap(level).map(|m| DepthStencilTexture2dMultisampleArrayLayerMipmap(m, self.1))
            }

            /// Access the main mipmap level of this layer.
            #[inline]
            pub fn main_level(&self) -> DepthStencilTexture2dMultisampleArrayLayerMipmap<'t> {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `DepthStencilTexture2dMultisampleArray`.
                ///
                /// Can be obtained by calling `DepthStencilTexture2dMultisampleArray::mipmap()`, `DepthStencilTexture2dMultisampleArray::main_level()`,
                /// `DepthStencilTexture2dMultisampleArrayLayer::mipmap()` or `DepthStencilTexture2dMultisampleArrayLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dMultisampleArrayMipmap<'t>(TextureAnyMipmap<'t>, &'t DepthStencilTexture2dMultisampleArray);

                impl<'a> ::std::ops::Deref for DepthStencilTexture2dMultisampleArrayMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> DepthStencilTexture2dMultisampleArrayMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                    /// Returns the number of array layers.
                    #[inline]
                    pub fn array_size(&self) -> u32 {
                        self.0.get_array_size().unwrap()
                    }
                

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t DepthStencilTexture2dMultisampleArray {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        
                    /// Access the first layer of this texture.
                    #[inline]
                    pub fn first_layer(&self) -> DepthStencilTexture2dMultisampleArrayLayerMipmap<'t> {
                        self.layer(0).unwrap()
                    }

                    /// Access a single layer of this texture.
                    #[inline]
                    pub fn layer(&self, layer: u32) -> Option<DepthStencilTexture2dMultisampleArrayLayerMipmap<'t>> {
                        self.0.layer(layer).map(|l| DepthStencilTexture2dMultisampleArrayLayerMipmap(l, self.1))
                    }
                }

                /// Represents a single layer of a mipmap level of a `DepthStencilTexture2dMultisampleArray`.
                #[derive(Copy, Clone)]
                pub struct DepthStencilTexture2dMultisampleArrayLayerMipmap<'t>(TextureAnyLayerMipmap<'t>, &'t DepthStencilTexture2dMultisampleArray);
            impl<'t> DepthStencilTexture2dMultisampleArrayLayerMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the number of samples of that image.
                #[inline]
                pub fn samples(&self) -> u32 {
                    self.0.get_samples().unwrap()
                }
            

                /// Returns the width and height of that image.
                #[inline]
                pub fn dimensions(&self) -> (u32, u32) {
                    (self.width(), self.height())
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for DepthStencilTexture2dMultisampleArrayLayerMipmap<'t> {
                                fn into(self) -> TextureAnyImage<'t> {
                                    self.0.into_image(None).unwrap()
                                }
                             }

                        impl<'t> ::framebuffer::ToDepthStencilAttachment<'t> for DepthStencilTexture2dMultisampleArrayLayerMipmap<'t> {
                            #[inline]
                            fn to_depth_stencil_attachment(self) -> ::framebuffer::DepthStencilAttachment<'t> {
                                ::framebuffer::DepthStencilAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::cubemap::Cubemap;

        /// Contains the implementation of `Cubemap`.
        pub mod cubemap {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::any::{self, TextureAny, TextureAnyLayer, TextureAnyMipmap};
            use texture::any::{TextureAnyLayerMipmap, TextureAnyImage, Dimensions};
            use texture::bindless::{ResidentTexture, BindlessTexturesNotSupportedError};
            use texture::get_format::{InternalFormat, InternalFormatType, GetFormatError};
            use texture::pixel_buffer::PixelBuffer;
            use texture::{TextureCreationError, Texture1dDataSource, Texture2dDataSource};
            use texture::{Texture3dDataSource, Texture2dDataSink, MipmapsOption, CompressedMipmapsOption};
            use texture::{RawImage1d, RawImage2d, RawImage3d, CubeLayer};
            use texture::pixel::PixelValue;

            use image_format::{ClientFormatAny, TextureFormatRequest};
            use image_format::{UncompressedFloatFormat, UncompressedIntFormat};
            use image_format::{CompressedFormat, DepthFormat, DepthStencilFormat, StencilFormat};
            use image_format::{CompressedSrgbFormat, SrgbFormat, UncompressedUintFormat};

            use backend::Facade;
            use uniforms::{UniformValue, AsUniformValue, Sampler};
            use framebuffer;
            use Rect;

            use GlObject;
            use TextureExt;
            use TextureMipmapExt;
            use gl;

    
/// A cube texture  containing floating-point data.
pub struct Cubemap(TextureAny);

                impl GlObject for Cubemap {
                    type Id = gl::types::GLuint;

                    #[inline]
                    fn get_id(&self) -> gl::types::GLuint {
                        self.0.get_id()
                    }
                }
            

                impl ::std::fmt::Debug for Cubemap {
                    #[inline]
                    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> Result<(), ::std::fmt::Error>
                    {
                        self.0.fmt(f)
                    }
                }
            

                impl ::std::ops::Deref for Cubemap {
                    type Target = TextureAny;

                    #[inline]
                    fn deref<'a>(&'a self) -> &'a TextureAny {
                        &self.0
                    }
                }
            

                            impl<'a> AsUniformValue for &'a Cubemap {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Cubemap(*self, None)
                                }
                            }

                            impl<'a> AsUniformValue for Sampler<'a, Cubemap> {
                                #[inline]
                                fn as_uniform_value(&self) -> UniformValue {
                                    UniformValue::Cubemap(self.0, Some(self.1))
                                }
                            }

                            impl Cubemap {
                                /// Builds a `Sampler` marker object that allows you to indicate
                                /// how the texture should be sampled from inside a shader.
                                ///
                                /// # Example
                                ///
                                /// ```no_run
                                /// # #[macro_use] extern crate glium;
                                /// # fn main() {
                                /// # let texture: glium::texture::Texture2d = unsafe {
                                /// # ::std::mem::uninitialized() };
                                /// let uniforms = uniform! {
                                ///     color_texture: texture.sampled().magnify_filter(glium::uniforms::MagnifySamplerFilter::Nearest)
                                /// };
                                /// # }
                                /// ```
                                #[inline]
                                pub fn sampled(&self) -> Sampler<Cubemap> {
                                    Sampler(self, Default::default())
                                }
                            }
                        
impl Cubemap {

            /// Determines the internal format of this texture.
            ///
            /// The backend may not support querying the actual format, in which case an error
            /// is returned.
            #[inline]
            pub fn get_internal_format(&self) -> Result<InternalFormat, GetFormatError> {
                self.0.get_internal_format()
            }
        

                /// Creates an empty texture.
                ///
                /// No mipmap level (except for the main level) will be allocated or generated.
                ///
                /// The texture will contain undefined data.
                #[inline]
                pub fn empty<F: ?Sized>(facade: &F, dimension: u32)
                                -> Result<Cubemap, TextureCreationError>
                                where F: Facade
                {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, MipmapsOption::NoMipmap.into(), Dimensions::Cubemap { dimension: dimension }).map(|t| Cubemap(t))}

                /// Creates an empty texture with a specific format.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_format<F: ?Sized>(facade: &F, format: UncompressedFloatFormat, mipmaps: MipmapsOption, dimension: u32) -> Result<Cubemap, TextureCreationError> where F: Facade {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
            
let t = any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Cubemap { dimension: dimension });
            t.map(|t| Cubemap(t))
}

                /// Creates an empty texture. Specifies whether is has mipmaps.
                ///
                /// The texture (and its mipmaps) will contain undefined data.
                #[inline]
                pub fn empty_with_mipmaps<F: ?Sized>(facade: &F, mipmaps: MipmapsOption, dimension: u32) -> Result<Cubemap, TextureCreationError> where F: Facade {
                    let format = TextureFormatRequest::AnyFloatingPoint;
            
any::new_texture::<_, u8>(facade, format, None, mipmaps.into(), Dimensions::Cubemap { dimension: dimension }).map(|t| Cubemap(t))
}

                /// Builds a new texture reference from an existing, externally created OpenGL texture.
                /// If `owned` is true, this reference will take ownership of the texture and be responsible
                /// for cleaning it up. Otherwise, the texture must be cleaned up externally, but only
                /// after this reference's lifetime has ended.
                pub unsafe fn from_id<F: Facade + ?Sized>(facade: &F,
                                                 format: UncompressedFloatFormat,
                                                 id: gl::types::GLuint,
                                                 owned: bool,
                                                 mipmap: MipmapsOption,
                                                 ty: Dimensions)
                                                 -> Cubemap {
                    let format = format.to_texture_format();
                    let format = TextureFormatRequest::Specific(format);
                    Cubemap(any::from_id(facade, format, id, owned, mipmap, ty))
                }
        

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the dimension of that image.
                #[inline]
                pub fn dimensions(&self) -> u32 {
                    self.width()
                }
            

            /// Returns the number of mipmap levels of the texture.
            ///
            /// The minimum value is 1, since there is always a main texture.
            #[inline]
            pub fn get_mipmap_levels(&self) -> u32 {
                self.0.get_mipmap_levels()
            }
        
            /// Turns the texture into a `ResidentTexture`.
            ///
            /// This allows you to use the texture in a much more efficient way by storing
            /// a "reference to it" in a buffer (actually not a reference but a raw pointer).
            ///
            /// See the documentation of `ResidentTexture` for more infos.
            #[inline]
            pub fn resident(self) -> Result<ResidentTexture, BindlessTexturesNotSupportedError> {
                ResidentTexture::new(self.0)
            }
        
            /// Access a single mipmap level of this texture.
            #[inline]
            pub fn mipmap(&self, level: u32) -> Option<CubemapMipmap> {
                self.0.mipmap(level).map(|m| CubemapMipmap(m, self))
            }

            /// Access the main mipmap level of this texture.
            #[inline]
            pub fn main_level(&self) -> CubemapMipmap {
                self.mipmap(0).unwrap()
            }
        }

                /// Represents a single mipmap level of a `Cubemap`.
                ///
                /// Can be obtained by calling `Cubemap::mipmap()`, `Cubemap::main_level()`,
                /// `CubemapLayer::mipmap()` or `CubemapLayer::main_level()`.
                #[derive(Copy, Clone)]
                pub struct CubemapMipmap<'t>(TextureAnyMipmap<'t>, &'t Cubemap);

                impl<'a> ::std::ops::Deref for CubemapMipmap<'a> {
                    type Target = TextureAnyMipmap<'a>;

                    #[inline]
                    fn deref(&self) -> &TextureAnyMipmap<'a> {
                        &self.0
                    }
                }
            impl<'t> CubemapMipmap<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the dimension of that image.
                #[inline]
                pub fn dimensions(&self) -> u32 {
                    self.width()
                }
            

                /// Returns the corresponding texture.
                #[inline]
                pub fn get_texture(&self) -> &'t Cubemap {
                    self.1
                }

                /// Returns the texture level.
                #[inline]
                pub fn get_level(&self) -> u32 {
                    self.0.get_level()
                }
        /// Provides an object representing a single layer of this cubemap.
                pub fn image(&self, layer: CubeLayer) -> CubemapImage<'t> {
                    CubemapImage(self.0.first_layer().into_image(Some(layer)).unwrap(), self.1)
                }
}

                /// Represents a single image of a mipmap level of a layer of `Cubemap`.
                #[derive(Copy, Clone)]
                pub struct CubemapImage<'t>(TextureAnyImage<'t>, &'t Cubemap);
            impl<'t> CubemapImage<'t> {

        /// Returns the width of that image.
        #[inline]
        pub fn width(&self) -> u32 {
            self.0.get_width()
        }
    

                /// Returns the height of that image.
                #[inline]
                pub fn height(&self) -> u32 {
                    self.0.get_height().unwrap()
                }
            

                /// Returns the dimension of that image.
                #[inline]
                pub fn dimensions(&self) -> u32 {
                    self.width()
                }
            
}
impl<'t> Into<TextureAnyImage<'t>> for CubemapImage<'t> {
                            fn into(self) -> TextureAnyImage<'t> {
                                self.0
                            }
                         }

                        impl<'t> ::framebuffer::ToColorAttachment<'t> for CubemapImage<'t> {
                            #[inline]
                            fn to_color_attachment(self) -> ::framebuffer::ColorAttachment<'t> {
                                ::framebuffer::ColorAttachment::Texture(self.into())
                            }
                        }
                    
}
pub use self::compressed_cubemap::CompressedCubemap;

        /// Contains the implementation of `CompressedCubemap`.
        pub mod compressed_cubemap {// the list of imports we need depends on the texture type, don't bother with this
            #![allow(unused_imports)]

            use std::borrow::Cow;

            use texture::